//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool Server::DoReceiveData(int xClient)
{
	if(SizeOfReceiveData[xClient] > 0)
    {
        return false;
    }

	if( FD_ISSET(Socket[xClient], &ReadFDS) )
	{
        char LocalReceiveData[MaxReceiveSize + 1];
		int Result = 0;

		// DoReceiveData- Receiving...

		Result = recv(Socket[xClient], LocalReceiveData, MaxReceiveSize, 0);

		if(Result == WSAEDISCON)
		{
			DisconnectClient(xClient);
			// DoReceiveData- WSAEDISCON
			return false;
		}

		if(Result == WSAECONNRESET)
		{
			DisconnectClient(xClient);
			// DoReceiveData- WSAECONNRESET
			return false;
		}

		if(Result == 0)
		{
			DisconnectClient(xClient);
			// DoReceiveData- Gracefull disconnect.
			return false;
		}

		if(Result == SOCKET_ERROR)
		{
			DisconnectClient(xClient);
			// DoReceiveData- Socket Error
			return false;
		}

		FreeClientReceive(xClient);

        RecvOffset[xClient] = 0;
		ReceiveData[xClient] = (char *) calloc(MaxReceiveSize, 1);
        //Decode(&BaseCommCript, LocalReceiveData, ReceiveData[xClient], Result);
        memcpy(ReceiveData[xClient], LocalReceiveData, Result);
		SizeOfReceiveData[xClient] = Result;

		return true;
	}

	return false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

